
	// some new patterns - jamshark70@dewdrop-world.net

Pwxrand : Pwrand { 
	embedInStream { |inval| 
		var item, 
			index = weights.windex, 
			totalweight, rnd, runningsum; 
		repeats.value.do({ |i| 
			item = list.at(index); 
			inval = item.embedInStream(inval); 

			totalweight = 1.0 - weights[index]; 
			rnd = totalweight.rand; 
			runningsum = 0; 
			while { 
				index = (index + 1) % weights.size; 
				runningsum = runningsum + weights[index]; 
				runningsum < rnd 
			}; 
		}); 
	} 
}

// deprecated; Pslide now has a wrap flag
PslideNoWrap : Pslide {
		// false = do not wrap at end
	*new { |list, repeats, len, step, start|
		^super.new(list, repeats, len, step, start, false)
	}
}

Pslide1 : Pslide {
    embedInStream { arg inval;
	    	var pos, item, lenStream, stepStream, lenn, stepp;
	    	pos = start;
	    	lenStream = len.asStream;
	    	stepStream = step.asStream;
	    	repeats.do({
	    			// nil protection -- stop immediately if lenStream or stepStream return nil
	    		(lenn = lenStream.next(inval)).notNil.if({
		    		lenn.do({ arg j;
		    			item = list.wrapAt(pos + j);
		    			inval = item.embedInStream(inval);
		    		});
		    		(stepp = stepStream.next(inval)).notNil.if({ pos = pos + stepp },
		    			{ ^inval });
		    	}, { ^inval });
	    	});
	     ^inval;  		
    }
}

PseqFunc : Pseq {
		// executes a function on the list item before embedding in stream
		// if func is nil, the item is used as is
	var	<func;
	
	*new { |list, repeats = 1, offset = 0, func|
		^super.new(list, repeats, offset).func_(func)
	}
	
	func_ { |f|
		f.isNil.if({ func = { |x| x } }, { func = f });
	}
	
	embedInStream {  arg inval;
		var item, offsetValue;
		offsetValue = offset.value;
		if (inval.eventAt('reverse') == true, {
			repeats.value.do({ arg j;
				list.size.reverseDo({ arg i;
					item = func.value(list.wrapAt(i + offsetValue));
					inval = item.embedInStream(inval);
				});
			});
		},{
			repeats.value.do({ arg j;
				list.size.do({ arg i;
					item = func.value(list.wrapAt(i + offsetValue));
					inval = item.embedInStream(inval);
				});
			});
		});
		^inval;
	}
}

PserFunc : PseqFunc {
	embedInStream {  arg inval;
		var item, offsetValue;
		offsetValue = offset.value;
		if (inval.eventAt('reverse') == true, {
			repeats.value.reverseDo({ arg i;
				item = func.value(list.wrapAt(i + offsetValue));
				inval = item.embedInStream(inval);
			});
		},{
			repeats.value.do({ arg i;
				item = func.value(list.wrapAt(i + offsetValue));
				inval = item.embedInStream(inval);
			});
		});
		^inval;
	}
}
